# 解图识物

## 项目概述
这是一个功能强大的浏览器插件，能够识别网页中的图片内容，提供物体识别、数量统计、动植物详细信息展示以及AI生成图片检测功能。

## 功能特性
1. **图片内容识别**：自动识别图片中的物体并统计数量
2. **动植物详细信息**：对识别到的动植物提供学名、体表特征、习性和分布区域等详细信息
3. **AI图片检测**：判断图片是否为AI生成，并提供检测率（百分比）
4. **安全的API密钥管理**：采用Base64加密存储API密钥，保护敏感信息
5. **剪切板截图识别**：支持直接识别系统剪贴板中的截图内容（Windows: Ctrl+V，macOS: Command+V）
6. **跨平台兼容性**：完全兼容Windows、macOS等操作系统的主流浏览器

## 安装方法
1. 将项目文件下载到本地
2. 在浏览器中打开扩展程序页面（chrome://extensions/）
3. 启用"开发者模式"
4. 点击"加载已解压的扩展程序"，选择项目文件夹

## 使用说明
1. 安装完成后，插件会自动在浏览器中运行
2. 鼠标悬停在任何图片上即可查看识别结果
3. 点击浏览器工具栏中的插件图标可打开独立识别窗口
4. 在独立窗口中可上传本地图片进行识别
5. 剪切板截图识别：在任意网页中，按下粘贴快捷键（Windows: Ctrl+V，macOS: Command+V），插件会自动检测并识别剪贴板中的截图内容

## 文件结构
```
├── _locales\            # 国际化语言文件
├── icons\               # 插件图标
├── app.js               # 应用主逻辑
├── content.js           # 网页内容脚本
├── manifest.json        # 插件配置文件
├── popup.css            # 弹窗样式
├── popup.html           # 弹窗HTML
├── popup.js             # 弹窗逻辑
└── README.md            # 项目说明文档
```

## 技术实现
- 使用HTML/CSS/JavaScript构建用户界面
- 通过Chrome扩展API与浏览器交互
- 调用AI视觉识别API处理图片内容
- 采用Base64加密保护API密钥