class ImageDetector {
    constructor() {
        this.encryptedApiKey = 'Nzk1MDE3NmEtZTg2MC00MzU2LWE1NzktNWM1N2JhNjM0N2Jl';
        this.apiKey = this.decryptApiKey(this.encryptedApiKey);
        this.modelId = 'ep-20250801193632-gcklq';
        this.apiUrl = 'https://ark.cn-beijing.volces.com/api/v3/chat/completions';
        this.initEventListeners();
    }

    decryptApiKey(encryptedKey) {
        return atob(encryptedKey);
    }

    initEventListeners() {
        const uploadArea = document.getElementById('uploadArea');
        const imageInput = document.getElementById('imageInput');
        const analyzeBtn = document.getElementById('analyzeBtn');
        const newAnalysis = document.getElementById('newAnalysis');
        const helpBtn = document.getElementById('helpBtn');
        const helpModal = document.getElementById('helpModal');
        const closeBtn = document.querySelector('.close-btn');

        uploadArea.addEventListener('click', () => imageInput.click());
        uploadArea.addEventListener('dragover', this.handleDragOver.bind(this));
        uploadArea.addEventListener('drop', this.handleDrop.bind(this));
        imageInput.addEventListener('change', this.handleFileSelect.bind(this));
        analyzeBtn.addEventListener('click', this.analyzeImage.bind(this));
        newAnalysis.addEventListener('click', this.resetInterface.bind(this));
        helpBtn.addEventListener('click', () => this.showHelpModal());
        closeBtn.addEventListener('click', () => this.hideHelpModal());
        helpModal.addEventListener('click', (e) => {
            if (e.target === helpModal) {
                this.hideHelpModal();
            }
        });
    }

    showHelpModal() {
        document.getElementById('helpModal').style.display = 'block';
    }

    hideHelpModal() {
        document.getElementById('helpModal').style.display = 'none';
    }

    handleDragOver(e) {
        e.preventDefault();
        e.currentTarget.classList.add('dragover');
    }

    handleDrop(e) {
        e.preventDefault();
        e.currentTarget.classList.remove('dragover');
        const files = e.dataTransfer.files;
        if (files.length > 0) {
            this.processFile(files[0]);
        }
    }

    handleFileSelect(e) {
        const file = e.target.files[0];
        if (file) {
            this.processFile(file);
        }
    }

    processFile(file) {
        if (!file.type.startsWith('image/')) {
            alert('请选择图片文件');
            return;
        }

        const reader = new FileReader();
        reader.onload = (e) => {
            this.displayPreview(e.target.result);
            this.currentImageData = e.target.result;
        };
        reader.readAsDataURL(file);
    }

    displayPreview(imageSrc) {
        document.getElementById('uploadArea').style.display = 'none';
        const previewArea = document.getElementById('previewArea');
        const previewImage = document.getElementById('previewImage');
        
        previewImage.src = imageSrc;
        previewArea.style.display = 'block';
    }

    async analyzeImage() {
        if (!this.currentImageData) return;

        this.showLoading();

        try {
            const response = await this.callAI(this.currentImageData);
            this.displayResults(response);
        } catch (error) {
            console.error('Analysis error:', error);
            this.showError('识别失败，请重试');
        }
    }

    async callAI(imageData) {
        const payload = {
            model: this.modelId,
            messages: [{
                role: 'user',
                content: [{
                    type: 'text',
                    text: '请识别这张图片中的所有物体，并统计每种物体的数量。对于动植物、花鸟虫鱼等生物类物体，请提供其学名、体表特征、习性、分布区域等详细信息。同时判断该图片是否为AI生成，并提供检测率（以百分比%表示）。提供图片的详细描述，包括场景、物体位置关系、颜色等信息。请以JSON格式返回结果，格式为：{"description": "图片详细描述", "isAIImage": 是否为AI图片(true/false), "aiDetectionRate": 检测率(百分比), "objects": [{"name": "物体名称", "scientificName": "学名", "physicalFeatures": "体表特征", "habitat": "习性", "distribution": "分布区域", "count": 数量}]}。只返回JSON，不要其他文字。'
                }, {
                    type: 'image_url',
                    image_url: {
                        url: imageData
                    }
                }]
            }]
        };

        const response = await fetch(this.apiUrl, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'Authorization': `Bearer ${this.apiKey}`
            },
            body: JSON.stringify(payload)
        });

        if (!response.ok) {
            throw new Error(`API request failed: ${response.status}`);
        }

        const data = await response.json();
        return this.parseAIResponse(data);
    }

    parseAIResponse(data) {
        try {
            const content = data.choices[0].message.content;
            const jsonMatch = content.match(/\{[\s\S]*\}/);
            if (jsonMatch) {
                return JSON.parse(jsonMatch[0]);
            }
            throw new Error('No valid JSON found in response');
        } catch (error) {
            console.error('Parse error:', error);
            return { objects: [{ name: '识别结果', count: '解析失败' }] };
        }
    }

    showLoading() {
        document.getElementById('previewArea').style.display = 'none';
        document.getElementById('loading').style.display = 'block';
        document.getElementById('results').style.display = 'none';
    }

    displayResults(data) {
        document.getElementById('loading').style.display = 'none';
        
        const resultsDiv = document.getElementById('results');
        const contentDiv = document.getElementById('resultContent');
        
        contentDiv.innerHTML = '';
        
        // 显示图片描述
        if (data.description) {
            const description = document.createElement('div');
            description.className = 'image-description';
            description.innerHTML = `<p><strong>图片描述:</strong> ${data.description}</p>`;
            contentDiv.appendChild(description);
        }

        // 显示AI图片检测结果
        if (data.isAIImage !== undefined) {
            const aiDetectionDiv = document.createElement('div');
            aiDetectionDiv.className = 'ai-detection-result';
            aiDetectionDiv.innerHTML = `<p><strong>AI图片检测:</strong> 是否为AI生成: ${data.isAIImage ? '是' : '否'} (检测率: ${data.aiDetectionRate}%)</p>`;
            contentDiv.appendChild(aiDetectionDiv);
        }
        
        // 显示物体识别结果
        if (data.objects && data.objects.length > 0) {
            const objectsTitle = document.createElement('h4');
            objectsTitle.textContent = '识别到的物体:';
            contentDiv.appendChild(objectsTitle);
            
            data.objects.forEach(obj => {
                const item = document.createElement('div');
                item.className = 'result-item';
                
                // 基础HTML结构
                let itemHTML = `
                    <div class="object-details">
                        <span class="object-name">${obj.name}</span>
                `;
                
                // 如果有学名，添加学名
                if (obj.scientificName) {
                    itemHTML += `
                        <span class="object-scientific-name"> (${obj.scientificName})</span>
                    `;
                }
                
                itemHTML += `
                    </div>
                    <span class="object-count">${obj.count}</span>
                `;
                
                // 添加体表特征、习性和分布信息（仅对生物类物体显示）
                if (obj.scientificName && (obj.physicalFeatures || obj.habitat || obj.distribution)) {
                    itemHTML += `
                    <div class="object-bio-details">
                        ${obj.physicalFeatures ? `<p><strong>体表特征:</strong> ${obj.physicalFeatures}</p>` : ''}
                        ${obj.habitat ? `<p><strong>习性:</strong> ${obj.habitat}</p>` : ''}
                        ${obj.distribution ? `<p><strong>分布:</strong> ${obj.distribution}</p>` : ''}
                    </div>
                `;
                }
                
                item.innerHTML = itemHTML;
                contentDiv.appendChild(item);
            });
        } else {
            contentDiv.innerHTML = '<p>未识别到物体</p>';
        }
        
        resultsDiv.style.display = 'block';
    }

    showError(message) {
        document.getElementById('loading').style.display = 'none';
        alert(message);
        this.resetInterface();
    }

    resetInterface() {
        document.getElementById('uploadArea').style.display = 'block';
        document.getElementById('previewArea').style.display = 'none';
        document.getElementById('loading').style.display = 'none';
        document.getElementById('results').style.display = 'none';
        document.getElementById('imageInput').value = '';
        this.currentImageData = null;
    }
}

document.addEventListener('DOMContentLoaded', () => {
    new ImageDetector();
});